@extends('layouts.app')

@section('title', 'Shopping Cart')

@section('content')
<div class="container mx-auto">
    <h1 class="text-2xl font-bold mb-4">Shopping Cart</h1>

    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    @if ($cartItems->isEmpty())
        <p>Your cart is empty.</p>
    @else
        <table class="table">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Total</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($cartItems as $item)
                    <tr>
                        <td>{{ $item->product->name }}</td>
                        <td>
                            <form method="POST" action="{{ route('cart.update', $item) }}">
                                @csrf
                                @method('PATCH')
                                <input type="number" name="quantity" value="{{ $item->quantity }}" min="1" class="form-control d-inline w-auto">
                                <button type="submit" class="btn btn-sm btn-primary">Update</button>
                            </form>
                        </td>
                        <td>${{ $item->price_at_add }}</td>
                        <td>${{ $item->price_at_add * $item->quantity }}</td>
                        <td>
                            <form method="POST" action="{{ route('cart.destroy', $item) }}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">Remove</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3" class="text-right font-bold">Subtotal:</td>
                    <td>${{ $subtotal }}</td>
                    <td></td>
                </tr>
            </tfoot>
        </table>

        <div class="mt-4">
            <a href="#" class="btn btn-success">Proceed to Checkout</a>
        </div>
    @endif
</div>
@endsection